﻿using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class used to move the background images] 
// Moves background images from top to bottom at a constant speed
// to give the impression that the Fighter is moving forward
//////////////////////////////////////////////////////////////////
public class SpaceController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Constant settings]
    const float SPACE_SPEED = -1.0f;     // Background scrolling speed
    const float START_POSITION = 12.2f;  // Start Y position of background movement
    const float END_POSITION = -12.2f;   // End Y position of background movement


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs once every frame]
    // (Unity standard function)
    void Update()
    {
        // Move the background at a constant speed downward
        transform.Translate(0, SPACE_SPEED * Time.deltaTime, 0);

        // When the background reaches the ending Y position, call ScrollEnd
        if (transform.position.y <= END_POSITION) ScrollEnd();
    }


    // [Function that moves the background from end position back to start position]
    void ScrollEnd()
    {
        // Move the background from the end Y position back to the start Y position
        transform.Translate(0, -1 * (END_POSITION - START_POSITION), 0);
    }
}
