﻿using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class for movement and collision detection of thrown weapons] 
// Movement and collision detection for the weapons (shuriken, sword, axe)
//////////////////////////////////////////////////////////////////
public class ShurikenController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Constant settings]
    const float SPEED_X = 0.05f;  // Movement speed of the thrown weapon

    // [Variables set from the Unity Editor]
    [SerializeField] bool isShuriken = true;  // Flag for the ninja’s weapon
    [SerializeField] float direction = 1;  // Direction of travel (1: right, -1: left)

    // [Private variables used in this program]    
    GameController cl_GameController;  // GameController class


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs only once at game start or when the game object is generated]
    // (Unity standard function)
    void Start()
    {
        // Get the GameController class from “GameController” game object in the scene 
        cl_GameController =
            GameObject.Find("GameController").GetComponent<GameController>();
    }


    // [Function that runs once every frame]
    // (Unity standard function)
    void Update()
    {
        // If GameController.isGameFinish is true
        if (cl_GameController.isGameFinish)
        {
            // Delete this weapon
            Destroy(gameObject);
        }

        // Move the weapon in the specified direction at the specified speed
        transform.Translate(direction * SPEED_X, 0, 0);
    }


    // [Function called when the weapon’s collider hits another collider]
    // (Unity standard function)
    private void OnTriggerEnter2D(Collider2D collision)
    {
        // If this weapon is shuriken and the tag of the object hit is “Enemy_Body”
        if (isShuriken && collision.gameObject.CompareTag("Enemy_Body"))
        {
            // Delete the parent game object of the object that was hit (the enemy)
            Destroy(collision.gameObject.transform.parent.gameObject);
            // Delete this weapon
            Destroy(gameObject);
        }

        // If this weapon is sword or axe and the tag of the object hit is “Ninja_Body”
        if (!isShuriken && collision.gameObject.CompareTag("Ninja_Body"))
        {
            // Delete the parent game object of the object that was hit (the ninja)
            Destroy(collision.gameObject.transform.parent.gameObject);

            // Call the GameOver function of the GameController class 
            cl_GameController.GameOver();

            // Delete this weapon
            Destroy(gameObject);
        }

        // If the tag of the object that was hit is “Border”
        if (collision.gameObject.CompareTag("Border"))
        {
            // Delete this weapon
            Destroy(gameObject);
        }
    }
}
