﻿using System.Collections;
using UnityEngine;

using UnityEngine.SceneManagement;  // Used for switching scenes
using UnityEngine.UI;  // Used for UI control processing

//////////////////////////////////////////////////////////////////
// [Class for Game Over, Stage Clear, and Restart]
// Handles Game Over processing, Stage Clear processing, and Restart processing
//////////////////////////////////////////////////////////////////
public class GameController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Constant settings]
    const float TIME_RESTART = 7.0f;  // Time from game end until restart

    // [Public variables accessed from other classes]
    public bool isGameFinish = false;  // Game end flag
    public int count_BackImage = 0;  // Counts the background which reached end position
    // For judging game clear (Because BackImageController runs on multiple game objects)

    // [Variables set from the Unity Editor]
    [SerializeField] GameObject go_GameStatus;
    // Game object for the text UI used to display Game Over / Stage Clear        


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Stage Clear processing function]
    public void StageClear()
    {
        // If the game end flag is already true, do not execute any further processing
        // (Prevents Stage Clear from running after Game Over)
        if (isGameFinish) return;

        // Set the game end flag to true
        isGameFinish = true;
        // Enable the text UI game object used for the Stage Clear display
        go_GameStatus.SetActive(true);
        // Display “Stage Clear” in the text UI
        go_GameStatus.GetComponent<Text>().text = "Stage Clear";

        // Call the coroutine function ReStart
        StartCoroutine(ReStart());
    }


    // [Game Over processing function]
    public void GameOver()
    {
        // If the game end flag is already true, do not execute any further processing
        // (Prevents Game Over from running after Stage Clear)
        if (isGameFinish) return;

        // Set the game end flag to true
        isGameFinish = true;
        // Enable the text UI game object used for the Game Over display
        go_GameStatus.SetActive(true);
        // Display “Game Over” in the text UI
        go_GameStatus.GetComponent<Text>().text = "Game Over";

        // Call the coroutine function ReStart
        StartCoroutine(ReStart());
    }


    // [Restart processing function]
    IEnumerator ReStart()
    {
        // Wait for the specified number of seconds
        yield return new WaitForSeconds(TIME_RESTART);

        // Load the “GameMain” scene
        SceneManager.LoadScene("GameMain");
    }
}
