﻿using System.Collections;
using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class for automatic enemy generation]
// Automatically generates green and red enemy at random intervals (right or left edge)
//////////////////////////////////////////////////////////////////
public class EnemyManager : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Constant settings]
    const float CREATE_TIME = 3.0f;  // Maximum time between enemy spawns

    // [Variables set from the Unity Editor]
    [SerializeField] GameController cl_GameController;  // GameController class
    [SerializeField] GameObject pre_Enemy1;  // Prefab for the green enemy (Enemy1)
    [SerializeField] GameObject pre_Enemy2;  // Prefab for the red enemy (Enemy2)


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs only once at game start or when the game object is generated]
    // (Unity standard function)
    void Start()
    {
        // Call the coroutine function Create_Enemy
        StartCoroutine(Create_Enemy());
    }


    // [Coroutine that spawns enemies]
    IEnumerator Create_Enemy()
    {
        // Wait for a random number of seconds in the specified range
        yield return new WaitForSeconds(Random.Range(0.1f, 1f));

        GameObject enemy;  // Define the enemy game object to be generated
        // If a random value is greater than 0.3, generate a green enemy (pre_Enemy1)
        if (Random.value > 0.3) enemy = Instantiate(pre_Enemy1);
        // If the random value is 0.3 or less, generate a red enemy (pre_Enemy2)
        else enemy = Instantiate(pre_Enemy2);

        // Move the generated enemy under the game object attached this script 
        enemy.transform.parent = this.gameObject.transform;

        // Get a random value from 1 to 3, and if it is 3
        if (Random.Range(1, 4) >= 3)
        {
            // Move the generated enemy to the specified position (left edge)
            enemy.transform.position = new Vector3(-11, -4.5f, 0);
            // Change the generated enemy to face right
            enemy.transform.localScale = new Vector3(0.6f, 0.6f, 1);

            // Set the EnemyController.direction variable of the generated enemy to 1
            enemy.GetComponent<EnemyController>().direction = 1;
        }
        // If the random value from 1 to 3 is 1 or 2
        else
        {
            // Move the generated enemy to the specified position (right edge)
            enemy.transform.position = new Vector3(11, -4.5f, 0);
        }

        // Get a random value within the specified range and wait for that seconds
        yield return new WaitForSeconds(Random.Range(CREATE_TIME - 2.0f, CREATE_TIME));

        // If isGameFinish is false, call the coroutine function Create_Enemy
        if (!cl_GameController.isGameFinish) StartCoroutine(Create_Enemy());
    }
}
