﻿using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class used to move the background images looking like the ninja is running] 
// Moves randomly selected background images from right to left at a constant speed
// Calls stage clear based on how many background images have shown
//////////////////////////////////////////////////////////////////
public class BackImageController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Constant settings]
    const int CLEAR_COUNT = 7;  // Number of background image moves until stage clear
    const float BACK_SPEED_X = -0.03f;  // Background image movement speed

    // [Variables set from Unity Editor]
    [SerializeField] GameController cl_GameController;  // GameController class
    [SerializeField] SpriteRenderer targetRenderer;  // SpriteRenderer for the background
    [SerializeField] Sprite[] backImage;  // Sprites' array used for the backgrounds


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs only once at game start or when the game object is generated]
    // (Unity standard function)
    void Start()
    {
        // In this game, Translate function is used in Update function for movement,
        // so to keep the feel of the controls consistent, we fix the frame rate.
        Application.targetFrameRate = 100;
    }


    // [Function that runs once every frame]
    // (Unity standard function)
    void Update()
    {
        // When the right arrow key is pressed and GameController.isGameFinish is false
        if (Input.GetKey(KeyCode.RightArrow) && !cl_GameController.isGameFinish)
        {
            // Move the background image left at the specified speed
            transform.Translate(BACK_SPEED_X, 0, 0);

            // If the background image has moved to the left of the end X-coordinate
            if (transform.position.x <= -17.6)
            {
                // Add 1 to GameController.count_BackImage
                cl_GameController.count_BackImage++;

                // Move the background image from the end back to the start X-coordinate 
                transform.position = new Vector3(28.9f, 0, 0);

                // If count_BackImage is less than the number of the stage-clear
                if (cl_GameController.count_BackImage < CLEAR_COUNT)
                {
                    // switch statement based on random value 1–5, for random background
                    switch (Random.Range(1, 6))
                    {
                        // When the random value is 1
                        case 1:
                            // Use the 1st image as the Sprite for the background image
                            targetRenderer.sprite = backImage[0];
                            break;

                        // When the random value is 2
                        case 2:
                            // Use the 2nd image as the Sprite for the background image
                            targetRenderer.sprite = backImage[1];
                            break;

                        // When the random value is 3
                        case 3:
                            // Use the 3rd image as the Sprite for the background image
                            targetRenderer.sprite = backImage[2];
                            break;

                        // When the random value is 4
                        case 4:
                            // Use the 4th image as the Sprite for the background image
                            targetRenderer.sprite = backImage[3];
                            break;

                        // When the random value is 5
                        case 5:
                            // Use the 5th image as the Sprite for the background image
                            targetRenderer.sprite = backImage[4];
                            break;
                    }
                }

                // When count_BackImage equals the number of the stage-clear
                else if (cl_GameController.count_BackImage == CLEAR_COUNT)
                {
                    // Use the 6th image (stage-clear image) for the background image
                    targetRenderer.sprite = backImage[5];
                }

                // When count_BackImage is greater than the number of stage clear + 1
                // (2 more background is needed to make the stage-clear visible)
                else if (cl_GameController.count_BackImage > CLEAR_COUNT + 1)
                {
                    // Call the StageClear function of the GameController class
                    cl_GameController.StageClear();
                }
            }
        }
    }
}
