﻿using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class for beam movement processing and deletion processing] 
// Perform beam movement and rotation, and delete under beam deletion conditions
//////////////////////////////////////////////////////////////////
public class BeamController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Public variables accessed from other classes]
    public float beam_Angle = 0;  // Angle to change the beam’s direction per frame
    // 0 for a straight beam, it will be a bending beam when set from the Fighter side

    // [Variables set from the Unity Editor]
    [SerializeField] float beam_Speed;  // Beam speed (change speed for the type)
    [SerializeField] SpriteRenderer targetRenderer;  // SpriteRenderer component


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs once every frame]
    // (Unity standard function)
    void Update()
    {
        // When the beam goes out of the screen
        if (!targetRenderer.isVisible)
        {
            // Delete the beam’s game object
            Destroy(gameObject);
        }

        // Rotate the beam clockwise by a constant angle
        transform.Rotate(0, 0, beam_Angle * Time.deltaTime);

        // Move the beam to the right (in local coordinates) at a constant speed
        transform.Translate(beam_Speed * Time.deltaTime * new Vector3(1, 0, 0));
    }
}
