﻿using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class used for moving the background image] 
// Move the background image from right to left at a constant speed, 
// expressing it as if the Fighter is advancing forward
//////////////////////////////////////////////////////////////////
public class BackImageController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Constant settings]
    const float BACK_SPEED = -1.0f;  // Background image movement speed
    const float START_POSITION = 20;  // X coordinate where background image starts
    const float END_POSITION = -20;  // X coordinate where background image ends


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs once every frame]
    // (Unity standard function)
    void Update()
    {
        // Move the background image leftward at a constant speed
        transform.Translate(BACK_SPEED * Time.deltaTime, 0, 0);

        // If the background image has moved to end position, call ScrollEnd function
        if (transform.position.x <= END_POSITION) ScrollEnd();
    }


    // [Function to return the background from the end position to the start position]
    void ScrollEnd()
    {
        // Move the background image from the end position back to the start position
        transform.Translate(-1 * (END_POSITION - START_POSITION), 0, 0);
    }
}
