﻿using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class used for controlling the Player bar]
// Operate the Player bar with the left and right arrow keys
//////////////////////////////////////////////////////////////////
public class PlayerController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Variables set from the Unity Editor]
    [SerializeField] float playerSpeed = 0.08f;  // Player bar speed
    // Adjust the speed of the Player bar from the Unity Editor side


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs only once when the game object is generated]
    // (Unity standard function)
    void Start()
    {
        // Since Player bar moves with Translate in Update function,
        // fix the frame rate so that the operability does not change
        Application.targetFrameRate = 100;
    }


    // [Function that runs once every frame]
    // (Unity standard function)
    void Update()
    {
        // When the right arrow key is pressed
        if (Input.GetKey(KeyCode.RightArrow))
        {
            // If the Player bar is to the left of the right edge
            if (transform.position.x < 2)
            {
                // Move to the right by the value of playerSpeed
                transform.Translate(playerSpeed, 0, 0);
            }
        }

        // When the left arrow key is pressed
        if (Input.GetKey(KeyCode.LeftArrow))
        {
            // If the Player bar is to the right of the left edge
            if (transform.position.x > -2)
            {
                // Move to the left by the value of playerSpeed
                transform.Translate(-playerSpeed, 0, 0);
            }
        }
    }
}
