﻿using UnityEngine;

//////////////////////////////////////////////////////////////////
// [Class used for controlling blocks]
// Block collision detection processing
//////////////////////////////////////////////////////////////////
public class BlockController : MonoBehaviour
{
    /////////////////////////////////
    // [Variable settings]
    /////////////////////////////////

    // [Public variables accessed from other classes]
    public float addSpeed = 0;  // Ball speed added when colliding with the ball

    // [Variables set from the Unity Editor]
    [SerializeField] int blockType = 0;  // Type of block
    // 0: Normal block, 1: Block that generates balls upon deletion, 2: Fixed block

    [SerializeField] int blockHP = 1;  // Durability of the block
    [SerializeField] int addBall = 0;  // Number of balls generated

    [SerializeField] GameObject prefab_Ball;  // Prefab for ball generation in the Scene

    // [Private variables used in this program] 
    GameObject go_Balls;  // Parent object of the balls generated by the block


    /////////////////////////////////
    // [Function settings]
    /////////////////////////////////

    // [Function that runs only once when the game object is generated]
    // (Unity standard function)
    void Start()
    {
        // Get the parent object of the balls generated by blocks existing in the Scene
        go_Balls = GameObject.Find("Balls");
    }


    // [Function called when the block’s collider collides with the ball’s collider]
    // (Unity standard function)
    void OnCollisionEnter2D(Collision2D collision)
    {
        // If the block type (blockType) is 0 or 1,
        if (blockType == 0 || blockType == 1)
        {
            // Decrease the block’s durability by 1
            blockHP--;

            // If the block’s durability is 0,
            if (blockHP == 0)
            {
                // If the block type (blockType) is 1,
                if (blockType == 1)
                {
                    // Repeat for the number of balls generated when the block is deleted
                    for (int i = 0; i < addBall; i++)
                    {
                        // Generate one ball at the block’s position on the Scene 
                        GameObject ball =
                            Instantiate(prefab_Ball, transform.position, Quaternion.identity);
                        // Move the generated ball under the parent object for balls
                        ball.transform.parent = go_Balls.transform;
                    }
                }

                // Delete the block from the Scene
                Destroy(gameObject);
            }
        }
    }
}
